#version 430


in vec3 posV[];
in vec2 uvV[];

out vec4 posG;
out vec2 uvG;

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}
vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}
vec3 rotateYZ3(vec3 p, float a) {
  return rotateYZ(vec4(p, 0.0), a).xyz;
}
vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}


layout(points) in;
layout(triangle_strip, max_vertices = 18) out;
//layout(line_strip, max_vertices = 15) out;


layout(binding=0, offset=0) uniform atomic_uint ac;

 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;
layout(binding=2) uniform sampler2D texEmit;

uniform float g_pikselos = 0.0;

uniform float g_partSize = 0.15;


float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

void main(void) {
    if (gl_in.length()<1) {
        return;
    }

    if (gl_in.length()>1) {
        return;
    }

    mat4 mvp = projectionMatrix * modelViewMatrix;
    vec4 pos = vec4(posV[0], 1.0);
    vec4 pW = mvp*pos;

    vec2 munUv = uvV[0];
    int primID = gl_PrimitiveIDIn;

    gl_PrimitiveID = gl_PrimitiveIDIn;

    float pSize = 0.02;

    float sizeX = pSize;
    float sizeY = pSize;
    float rotAngle = 0.0;
    float ar = 1.0;
    vec4 k;

    k = rotateXY(vec4(-sizeX, -sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(0.0, 0.0);
    EmitVertex();

    k = rotateXY(vec4(sizeX, -sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(1.0, 0.0);
    EmitVertex();

    k = rotateXY(vec4(-sizeX, sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(0.0, 1.0);
    EmitVertex();


    k = rotateXY(vec4(sizeX, sizeY, 0.0, 0.0), rotAngle);
    gl_Position = pW+vec4(k.x*ar, k.y, 0.0, 0.0);
    posG = gl_Position;
    uvG = vec2(1.0, 1.0);
    EmitVertex();

    EndPrimitive();
}
